/* ThinkPad Windows 95 Setup Diskette */
/* trace ?r */

call GETVARS

MAIN:

if alldone = 1 then call AGAIN
if flag =1 then call DONE

GETOPT:
if domenu = 0 then
   do
     status = 'MENU'
     call DISPMSG
     domenu = 1
     rc = RXGETKEY('NOECHO')
     select
       when rc = 1 then call OPTION1
       when rc = 2 then call OPTION2
       when rc = 3 then call OPTION3
       otherwise
         do
           status = 'BADOPT'
           call DISPMSG
           pause
           domenu = 0
           flag = 0
         end /* do */
     end /* select */
   end /* do */
else call OPTION1

if flag = 0 then call GETOPT

DONE:
exit


GETVARS:
statusfile = 'a:\status.txt'
rc = RXFINFO(statusfile)
if rc = '' then
   do
     rc = RXCREATE(statusfile)
     call charout statusfile,'00000'
   end /* do */
dtitle = 0
vesaf = 0
bios = charin(statusfile,1)
if bios = 0 then domenu = 0
   else domenu = 1
vesa = charin(statusfile,2)
delos2 = charin(statusfile,3)
remscr = charin(statusfile,4)
alldone = charin(statusfile,5)
backup = 0
WININI = 'C:\WINDOWS\WIN.INI'
WINE95 = 'C:\WINDOWS\WIN.E95'
CONFIG = 'C:\CONFIG.SYS'
red = '1b'x||'[31m'
normal = '1b'x||'[0m'
sysname1 = '701C 701CS 755CE 755CD 755CX 755CV 755CDV 340CSE'
sysname2 = '360 355 370C 755C 755CS'
return


OPTION1:    /* Setup ThinkPad */

if bios = 0 then
   do
    status = 'BIOS'
    call DISPMSG
    rc = charout(statusfile,'1',1)
    bios = 1
    flag = 1
  end
else
  do
    status = 'SECOND'
    call DISPMSG
    pause
    if backup = 0 then call BACKUP
    call CHECKSYS
/*  flag = 1  */
  end /* do */
return  /* END OF OPTION 1 */


/* Analize System */
CHECKSYS:

echo off
status = 'GETMOD'
call DISPMSG
parse upper pull sysname
if sysname = 'QUIT' then
   do
     flag = 0
     domenu = 0
     call RESTORE
     return
   end
rc =  wordpos(sysname,sysname1,1)
if rc <> 0 then
   do
     call FINDOS2
     call FINDWEL
     call INSTIT
   end
else
  do
    rc = wordpos(SYSNAME,sysname2,1)
    if rc <> 0 then
       do
         call FINDOS2
         call FINDWEL
         call FNDVESA
         call INSTIT
       end
    else
      do
        status = 'NOMOD'
        call DISPMSG
        pause
        call CHECKSYS
      end /* do */
  end /* do */
return


/* Find Operating System */
FINDOS2:

if delos2 <> 0 then return
else
   do
     flag = 0
     rc = RXISDIR('C:\OS2')
     if rc = 1 then
       do
         status = 'FOUNDOS'
         call DISPMSG
         rc = RXGETKEY('NOECHO')
         parse upper var rc rc
         if rc <> 'Y' then
         do
           status = 'NOINSTALL'
           call DISPMSG
           pause
           call RESTORE
           domenu = 0
           call GETOPT
         end /* do */
         status = 'POSITIVE'
         call DISPMSG
         rc = RXGETKEY('NOECHO')
         parse upper var rc rc
         if rc <> 'Y' then
         do
           status = 'NOINSTALL'
           call DISPMSG
           pause
           call RESTORE
           domenu = 0
           call GETOPT
         end /* do */
         status = 'REMOVEOS'
         call DISPMSG
         'deltree c:\os2 < yes.txt > nul'
         'deltree c:\psfonts < yes.txt > nul'
         'deltree c:\spool < yes.txt > nul'
         'deltree c:\desktop < yes.txt > nul'
         'deltree c:\nowhere < yes.txt > nul'
         'deltree c:\nowhere1 < yes.txt > nul'
         'deltree c:\maintena < yes.txt > nul'
         'deltree c:\mmos2 < yes.txt > nul'
         'deltree c:\disketts\os2v3 < yes.txt > nul'
         'deltree c:\viewer < yes.txt > nul'
         'deltree c:\lanlk < yes.txt > nul'
         'deltree c:\p2p < yes.txt > nul'
         'deltree c:\tcpip < yes.txt > nul'
         'deltree c:\faxwos2 < yes.txt > nul'
         'deltree c:\cservos2 < yes.txt > nul'
         'deltree c:\mwaveos2 < yes.txt > nul'
         'deltree c:\ibmworks < yes.txt > nul'
         'deltree c:\halite < yes.txt > nul'
         'del C:\ACLLOCK.LST > nul'
         'del C:\DELIVERY.SYS > nul'
         'del C:\README. > nul'
         'del C:\SOM.IR > nul'
         'del C:\*.ADD > nul'
         'del c:\ULTITOOL.INI > nul'
         'del c:\TEDIT.EXE > nul'
         'del c:\TEDIT.HLP > nul'
         'del c:\CDFS.IFS > nul'
         /* 'del c:\windows\os2warp.grp > nul' */
         'ATTRIB -r -h -s C:\OS2KRNL. > nul'
         'del C:\OS2KRNL. > nul'
         'ATTRIB -r -h -s C:\EA?DATA.?SF > nul'
         'del C:\EA?DATA.?SF > nul'
         'ATTRIB -r -h -s C:\WP?ROOT.?SF > nul'
         'del C:\WP?ROOT.?SF > nul'
         'ATTRIB -r -h -s C:\OS2LDR. > nul'
         'del C:\OS2LDR. > nul'
         'ATTRIB -r -h -s C:\OS2LDR.MSG > nul'
         'del C:\OS2LDR.MSG > nul'
         'ATTRIB -r -h -s C:\OS2VER. > nul'
         'del C:\OS2VER. > nul'
         'ATTRIB -r -h -s C:\OS2BOOT. > nul'
         'del C:\OS2BOOT. > nul'
         'ATTRIB -r -h -s C:\OS2DUMP. > nul'
         'del C:\OS2DUMP. > nul'
         'ATTRIB -r -h -s C:\OS2LOGO. > nul'
         'del C:\OS2LOGO. > nul'
         'del c:\os2tools\gotowarp.exe > nul'
         status = 'OSREMOVED'
         call DISPMSG
         rc = charout(statusfile,'1',3)
         FLAG = 1
         pause
   end /* do */
return


RESTORE:
'copy 'wine95 winini '>> a:\result.txt'
rc = FILESCOPIED('a:\result.txt')
if rc = 0 then
   do
     status = 'NORESTORE'
     call DISPMSG
     pause
   end
else
   do
     status = 'RESTORE'
     call DISPMSG
     pause
   end /* do */
return


/* remove STRTSCR */
FINDWEL:

strtpos = 0
endpos = 0
linenum = 0
status = 'WELCOME'
call DISPMSG
do until lines(WINE95) = 0
   linenum = linenum + 1
   READLINE = linein(WINE95)
   parse upper var READLINE READLINE
   strtpos = pos('C:\SCREENS\',READLINE)
   if strtpos <> 0 then
      do
        endpos = pos(' ',READLINE,strtpos)
        if endpos = 0 then
           do
             READLINE = delstr(READLINE,strtpos)
           end
        else
           do
             endpos = endpos - strtpos + 1
             READLINE = delstr(READLINE,strtpos,endpos)
           end
        rc = lineout(WININI,READLINE,linenum)
        rc = charout(statusfile,'1',4)
      end /* do */
   else rc = lineout(WININI,READLINE,linenum)
end /* do */
FLAG = 1
pause
return


FNDVESA:
status = 'FINDVESA'
call DISPMSG
if vesaf = 0 then
   do
     i = 0
     do until lines(CONFIG)=0
        READLINE = linein(CONFIG)
        parse upper var READLINE READLINE
        i = i + 1
        fvesa  = wordpos('DEVICE=C:\IBMVESA\VESA.EXE',READLINE)
        fvesah = wordpos('DEVICEHIGH=C:\IBMVESA\VESA.EXE',READLINE)
        if fvesa = 1 then vesaf = 1
        if fvesah = 1 then vesaf = 1
        if fvesa = 1 | fvesah = 1 then
           do
             remed = wordpos('REM',READLINE)
             if remed <> 0 then vesaf = 0
           end /* do */
     end /* do */
     if vesaf <> 1 then
       do
         status = 'VESANO'
         call DISPMSG
         pause 'Press any key to begin installation...'
         'ren a:\config.sys config.dsk > nul'
         'copy c:\config.sys a:\config.sys > nul'
         'vinstall'
         'copy a:\config.sys c:\config.sys < yes.txt > nul'
         'del a:\config.sys > nul'
         'ren a:\config.dsk config.sys > nul'
         vesaf = 1
         rc = charout(statusfile,'1',2)
         pause
       end /* do */
     else
       do
         status = 'VESAYES'
         call DISPMSG
       end /* do */
   end /* do */
   FLAG = 1
return


OPTION2:    /* VIEW README.TXT */
'BROWSE A:\README.TXT'
flag = 0
domenu = 0
dtitle = 0
return  /* END OF OPTION 2 */


OPTION3:    /* EXIT PROGRAM */
status = 'EXIT'
call DISPMSG
flag = 1
if restore = 0 then call RESTORE
return


INSTIT:
status = 'DONE'
call DISPMSG
rc = charout(statusfile,'1',5)
flag = 1
return

AGAIN:
status = 'AGAIN'
call DISPMSG
flag = 1
return


BACKUP:
'copy c:\config.sys c:\config.e95 > nul'
'copy c:\autoexec.bat c:\autoexec.e95 > nul'
'copy c:\windows\win.ini c:\windows\win.e95 > nul'
'copy c:\windows\system.ini c:\windows\system.e95 > nul'
'del 'WININI
backup = 1
return


FILESCOPIED:
parse arg file
do while lines(file)
   line = linein(file)
end /* do */
parse var line n 'file(s)' test
n = STRIP(n)
if (test = 'copied' & n > 0) then return n
else return 0
return


DISPMSG:
do i = 2 to 21
   msg.i = ''
end /* do */

msg.1  = 'ThinkPad Windows 95 Setup Diskette'

select
  when status = 'MENU' then do
     msg.4 = '1) Install Windows 95 on your ThinkPad system'
     msg.5 = '2) View README.TXT for additional information on installation'
     msg.6 = '3) Exit'
  end /* menu */
  when status = 'BADOPT' then do
     msg.4 = 'You selected an incorrect option!  Please try again.'
  end /* bad option selected */
  when status = 'BIOS' then do
     msg.4 = 'Welcome!  This diskette will prepare your system for installation of Windows'
     msg.5 = '95.  The first step in the process is to update the flash ROM (BIOS) on your'
     msg.6 = 'system to ensure Plug and Play will function properly.'
     msg.8  = red'NOTE:  It is possible that your system already has the required level'
     msg.9  = '       of ROM BIOS.  In this case, you will get a message that your'
     msg.10 = '       system does not need to be updated.  If this happens, continue'
     msg.11 = '       as if the BIOS had been updated.'normal
     msg.13 = 'Please remove the Windows 95 Setup Disk from Drive A:  Insert the'
     msg.14 = 'PROGRAM SERVICE DISKETTE in drive A:, then reboot your system by powering'
     msg.15 = '"off" then "on", or pressing CTRL+ALT+DEL.'
     msg.17 = 'When the service diskette is finished updating your system, remove it from'
     msg.18 = 'the diskette drive and re-insert the Windows 95 Setup Disk.  Then reboot'
     msg.19 = 'your system on more time by powering "off" and then "on", or pressing'
     msg.20 = 'CTRL+ALT+DEL.'
  end /* bios update */
  when status = 'SECOND' then do
     msg.4 = 'Welcome back.  Your BIOS has been updated for Plug and Play support.  The'
     msg.5 = 'Setup disk will now make adjustments to your system to continue installation'
     msg.6 = 'Your system files (CONFIG.SYS, AUTOEXEC.BAT, WIN.INI, SYS.INI) will be saved'
     msg.7 = 'in their respective directories with an .E95 extension.'
  end /* second boot */
  when status = 'FOUNDOS' then do
     msg.4 = 'Your system currently has OS/2 installed.  Windows 95 and OS/2 will not'
     msg.5 = 'run correctly together.  If you would like to continue installation.'
     msg.6 = 'OS/2 will be removed from your system along with all preinstalled OS/2'
     msg.7 = 'applications.'
     msg.9 = 'If you have not used the diskette factory application to create diskettes,'
     msg.10 = 'you will have no way to reinstall DOS, Windows 3.1, or OS/2 Warp should you'
     msg.11 = 'later choose to.'
     msg.13 = 'Are you sure you want to continue and erase OS/2? (Y/N)'
  end /* found OS */
  when status = 'NOINSTALL' then do
     msg.4 = 'You have chosen not to continue installation.  Please choose option'
     msg.5 = '(3) Exit from the main menu to exit the installation.'
  end /* do not install */
  when status = 'POSITIVE' then do
     msg.4='You have selected to remove OS/2. Are you positive you want to do this?(Y/N)'
  end /* positive */
  when status = 'REMOVEOS' then do
      msg.4='OS/2 will now be removed from your ThinkPad.  Please wait.....'
  end /* removing OS */
  when status = 'OSREMOVED' then do
      msg.4 = 'OS/2 and preloaded OS/2 applications have been removed.'
  end /* OS removed */
  when status = 'NORESTORE' then do
     msg.4 = 'ERROR! Please select Option (3) and copy C:\WINDOWS\WIN.E95 to C:\WINDOWS\WIN.INI'
  end /* restore not successful */
  when status = 'RESTORE' then do
     msg.4 = 'System files have been restored.'
  end /* restored system files */
  when status = 'WELCOME' then do
     msg.4 = 'The welcome screens that we displayed when you started your system for'
     msg.5 = 'the first time will no longer be automatically displayed.  (The programs'
     msg.6 = 'are not being deleted).'
     msg.8 = 'Please wait...'
  end /* Welcome Screens */
  when status = 'FINDVESA' then do
     msg.4='Checking for VESA video driver......'
  end /* find VESA */
  when status = 'VESANO' then do
     msg.4='You do not have the VESA video driver installed.  This driver is'
     msg.5='required for Windows 95 to be installed properly.  The next screen'
     msg.6='you see will be the VESA drivers installation program.'
     msg.8=red'NOTE: If you will not be using an external monitor, please choose'
     msg.9='      IBM 8511/8512/8513/8517/8518 from the list.  Otherwise,'
     msg.10='      choose the type that matches your external monitor.'normal
  end /* no vesa found */
  when status = 'VESAYES' then do
     msg.4 = 'VESA video driver already installed.'
  end /* vesa found */
  when status = 'EXIT' then do
     msg.4 = 'Remove the ThinkPad Windows 95 Setup diskette and reboot your system by'
     msg.5 = 'powering "off" then "on", or pressing CTRL+ALT+DEL.'
  end /* exit program */
  when status = 'GETMOD' then do
     msg.4 = 'Please enter your ThinkPad model name (ie. 701C, 755CE, etc.)'
     msg.5 = 'or enter "QUIT" to return to the main menu.'
  end /* get model name */
  when status = 'NOMOD' then do
     msg.4 = 'You entered an invalid ThinkPad model name or this diskette is not'
     msg.5 = 'neccessary for your particular ThinkPad.  Please try again.'
  end /* no model found */
  when status = 'DONE' then do
     msg.4 = 'Your system is now prepared for Windows 95 installation.  Remove the Windows'
     msg.5 = '95 Setup diskette and reboot your system by powering "off" then "on", or'
     msg.6 = 'pressing CTRL+ALT+DEL.'
     msg.8 = 'When you reboot, start Windows 3.1.  From the Program Manager menu bar,'
     msg.9 = 'select File, Run, then enter x:\SETUP (where "x" is the drive letter'
     msg.10 = 'for your diskette drive or CD-ROM drive, depending on your Windows 95'
     msg.11 = 'upgrade package.'
     msg.13 = red'NOTE:  During installation, Windows 95 will ask if you would like to'
     msg.14 = '       make an emergeny recovery disk.  You should choose not to make'
     msg.15 = '       this disk until Windows 95 is fully installed and restarted.'
     msg.17 = '       If the emergency diskette is created before installation of'
     msg.18 = '       Windows 95 is complete, all features of your system will not'
     msg.19 = '       be supported by the emergency disk.  If created after install,'
     msg.20 = '       it will contain all necessary drivers for the system to function'
     msg.21 = '       properly.'normal
  end  /* done */
  when status = 'AGAIN' then do
     msg.4 = 'Your ThinkPad has already gone through the setup process.  Please remove'
     msg.5 = 'the ThinkPad Windows 95 Setup diskette and reboot your system.'
  end  /* Do */
  otherwise do
     nop
  end /* otherwise */
end /* SELECT */

rc = RXCLS(7)
say CENTER(msg.1,79)
do i = 2 to 21
   say msg.i
end /* do */

return
