/* Rexx program to fix up the OS/2 desktop for OS/2 Performance system
   to
   1.  Put shadow of A: drive on desktop as for OS/2 2.11 system
   2.  Remove startup of launchpad

       This is accomplished by:

       a.  Edit CONFIG.SYS to add line:
           SET RESTARTOBJECTS=STARTUPFOLDERSONLY
           Remove string ",LAUNCHPAD" from SET AUTOSTART= line

       b.  Add shadow of ADRIVE on desktop by call SysIni:
            Create shadow of A Drive on desktop as in OS/2 2.11
            "PM_Workplace:InstallDiskOnDesktop" "A" "ICONPOS=80 8"
            Note that WARP apparently does not honor iconpos keyword,
            as the new icon goes into next landing slot on desktop.

       c.  Edit STARTUP.CMD to add start for ourselves by adding lines
           to start phase 2 of srd2fix to complete processing and to
           erase the temporary changes to CONFIG.SYS and startup.cmd.

       d.  Invoke SETBOOT /IBD:C
           reboot the system to shutdown launchpad and run ourselves

   3.  Delete our copy of CONFIG.SYS and rename the backup
       Do same for startup.cmd

   4.  Terminate.  The system is now changed as we want it.

   Bruce E. Hogman   t/l 443-5047,  IBM Customer Migration Support,
                                    IBM PSP, Boca Raton FL 33431
   Written for Rich Schwerdtfeger of IBM Special Needs group
   Version 19940929 updated to correctly invoke existing startup.cmd
   for next IPL that cleans up files.

*/
ourversion='940929'
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

ADriveID="<A_Drive_Shadow>" /* OBJECTID to associate with shadow */

/* get boot drive letter from environment */
BootDrive=left(value('COMSPEC',,'OS2ENVIRONMENT'),2)
bRESTARTOBJ=0 /* 1=config.sys has restartobjects line already */
bLAUNCHPAD=0  /* 1=config.sys was updated to remove autostart launchpad */
bADriveExists=0 /* 1=a: drive object already created */

parse source osname cmdname ourname
if left(ourname,2) <> BootDrive then
   do
      DisketteDrive=left(ourname,2)
      newname=BootDrive||'\os2\install\'||filespec('n',ourname)
      'copy' ourname newname
      ourname=newname
      if DisketteDrive = 'A:' | DisketteDrive='B:' then
      do
      say '*********************************************'
      say '*********************************************'
      say '**                                         **'
      say '** PLEASE REMOVE DISKETTE FROM DRIVE 'DisketteDrive'    **'
      say '**                                         **'
      say '** THIS MUST BE DONE BEFORE REBOOT.        **'
      say '**                                         **'
      say '** PROCESSING WILL CONTINUE...             **'
      say '**                                         **'
      say '*********************************************'
      say '*********************************************'
      Call SysSleep 5
      end
      else say ourname 'copied to' BootDrive||'\os2\install\ ' ||,
      'for Phase 2 use.'
   end

parse arg runoption backupconfig backupstartup junk


/* Do Phase 1 processing */
if runoption <> '/2' then do

   say osname cmdname ourname ourversion 'Phase 1'

   bRESTARTOBJ=0 /* assume no restart line */

   /* make temp file name and copy CONFIG.SYS to it */
   BackupConfig=SysTempFileName(BootDrive || '\config.???')
   ProdConfig=BootDrive || '\CONFIG.SYS'
   Call Stream BackupConfig,'c','open write'
   bLAUNCHPAD=0
   do while lines(ProdConfig)
      xstr=linein(ProdConfig)
      if 0 < pos("AUTOSTART=",translate(xstr)) then
         do
            xstr=translate(xstr)
            say 'CONFIG.SYS AUTOSTART line='xstr
            select
               when 0 < pos(" LAUNCHPAD,",xstr) then
                  do
                     bLAUNCHPAD=1
                     loff=pos(" LAUNCHPAD,",xstr)
                     roff=loff+11
                     xstr=substr(xstr,1,loff)||substr(xstr,roff)
                  end
               when 0 < pos(",LAUNCHPAD",xstr) then
                  do
                     bLAUNCHPAD=1
                     loff=pos(",LAUNCHPAD",xstr)-1
                     roff=loff+11
                     xstr=substr(xstr,1,loff)||substr(xstr,roff)
                  end
               when 0 < pos(" LAUNCHPAD ",xstr) then
                  do
                     bLAUNCHPAD=1
                     loff=pos(" LAUNCHPAD ",xstr)
                     roff=loff+11
                     xstr=substr(xstr,1,loff)||substr(xstr,roff)
                  end
               otherwise nop
            end
            say 'CONFIG.SYS AUTOSTART line='xstr
            if bLAUNCHPAD then
               say 'AUTOSTART LAUNCHPAD REMOVED.'
            Call SysSleep 3
         end
      Call Lineout BackupConfig,xstr
   end
   Call Stream BackupConfig,'c','close'
   Call Stream ProdConfig,'c','close'
   say 'CONFIG.SYS copied to backup' BackupConfig

   /* synchronize both files if we edited CONFIG.SYS during copy */
   '@copy' BackupConfig ProdConfig

   /* see if restart line is already in CONFIG.SYS */
   do while lines(ProdConfig)
      xstr = linein(ProdConfig)
      if 0 < pos('RESTARTOBJECTS=STARTUPFOLDERSONLY',xstr) then
         bRESTARTOBJ=1
   end
   Call Stream ProdConfig,'c','close'

   /* add line to CONFIG.SYS */
   if \bRESTARTOBJ then
      do
         say 'Adding restart line to CONFIG.SYS'
         call lineout ProdConfig,''
         urc=lineout(ProdConfig,'SET RESTARTOBJECTS=STARTUPFOLDERSONLY')
         call Stream ProdConfig,'c','close'
      end
   else say 'CONFIG.SYS already has restartobjects line.'

   /* Check to see if there is now startup.cmd file present */
   bStartUpExists=0
   ProdStartup=BootDrive || '\startup.cmd'
   if ''<>Stream(ProdStartup,'c','query exists')
   then bStartupExists=1

   /* make backup copy of startup.cmd */
   BackupStartup=SysTempFileName(BootDrive || '\startup.???')
   if bStartupExists then
      do
         'copy' ProdStartup BackupStartup
         'erase' ProdStartup
      end
   call stream ProdStartup,'c','open write'

   /* construct new startup.cmd to run phase 2 */
   sx.0=2
   sx.1='START "SRD2FIX 2" /c /win' ourname '/2' backupconfig backupstartup
   sx.2='exit'
   call stream ProdStartup,'c','open write'
   do i=1 to sx.0
      say sx.i
      call lineout ProdStartup,sx.i
   end

   call stream ProdStartup,'c','close'

   /* Create a drive using wps */
   /* 1st, check for existence of object on desktop already */
   src=SysSetObjectData(ADriveID,"NOPRINT=YES;")
   if \src then
   do
      say "A: Drive shadow will be created."
      Call SysIni 'USER',,
      "PM_Workplace:InstallDiskOnDesktop","A","ICONPOS=80 8;"||,
      "OBJECTID="||AdriveID
   end
   else say "A: Drive shadow already exists."

   /* invoke setboot to reboot and stop launchpad and run phase 2 */
   'setboot /ibd:' || BootDrive
end

else do /* run phase 2 of srd2fix */

   say ourname ourversion 'Phase 2'

   if ''<>stream(backupconfig,'c','query exists') then
      do
         'erase' BootDrive || '\CONFIG.SYS'
         'rename' backupconfig 'CONFIG.SYS'
      end

   'erase' BootDrive || '\startup.cmd'
   if ''<>stream(backupstartup,'c','query exists') then
      do
         'rename' backupstartup 'startup.cmd'
         '@start' BootDrive || '\startup.cmd'
      end
   say ''
   say ourname 'processing has completed.'

end
